package com.squarepeghires.githubing.git;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.net.URL;
import java.time.Instant;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.SneakyThrows;

@RequiredArgsConstructor
@Getter
public final class GitCommit {
    @JsonAlias("html_url")
    private final URL url;

    private final String sha;
    private final GitUser author;

    @Setter
    private String message;

    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @Setter
    private Instant date;

    @SneakyThrows
    @JsonSetter("commit")
    public void setCommit(JsonNode commitNode) {
        message = commitNode.get("message").textValue().split("\n", 2)[0];
        date = new StdDateFormat()
                .parse(commitNode.get("committer").get("date").textValue())
                .toInstant();
    }
}
