package com.squarepeghires.githubing.git;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import lombok.AllArgsConstructor;

@AllArgsConstructor
public final class GitUser {
    private String login;
    private URL url;
    private URL avatarUrl;

    public String getLogin() {
        return login;
    }

    @JsonProperty("url")
    public URL getUrl() {
        return url;
    }

    @JsonProperty("avatarUrl")
    public URL getAvatarUrl() {
        return avatarUrl;
    }

    @JsonProperty("html_url")
    public void setUrl(URL url) {
        this.url = url;
    }

    @JsonProperty("avatar_url")
    public void setAvatarUrl(URL avatarUrl) {
        this.avatarUrl = avatarUrl;
    }
}
