package com.squarepeghires.githubing.github;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.squarepeghires.githubing.git.GitCommitStatus;
import java.io.IOException;

public class GitHubCommitStatusDeserializer extends StdDeserializer<GitCommitStatus> {
    public GitHubCommitStatusDeserializer() {
        this(null);
    }

    protected GitHubCommitStatusDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public GitCommitStatus deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode rootNode = p.readValueAsTree();
        String status = rootNode.get("state").textValue();

        return switch (rootNode.get("state").textValue()) {
            case "pending" -> GitCommitStatus.PENDING;
            case "success" -> GitCommitStatus.SUCCESS;
            case "failure" -> GitCommitStatus.FAILURE;
            default -> throw new InvalidFormatException(p, "Unexpected commit status", status, GitCommitStatus.class);
        };
    }
}
