package com.squarepeghires.githubing.github;

import com.squarepeghires.githubing.git.GitCommit;
import com.squarepeghires.githubing.git.GitCommitStatus;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GitHubController {
    private final GitHubClient gitHubClient;

    public GitHubController(GitHubClient gitHubClient) {
        this.gitHubClient = gitHubClient;
    }

    /**
     * Wired in repo name for simplicity
     */
    @GetMapping("/api/commits/typescript")
    public List<GitCommit> lastCommits() {
        return gitHubClient.getCommits("microsoft", "TypeScript", 25);
    }

    @GetMapping("/api/commits/typescript/{sha}")
    public GitCommitStatus commitStatus(@PathVariable String sha) {
        return gitHubClient.getStatus("microsoft", "TypeScript", sha);
    }
}
