package com.squarepeghires.githubing.github;

import static org.junit.jupiter.api.Assertions.assertEquals;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.squarepeghires.githubing.git.GitCommit;
import java.util.List;

public class GitHubAssertions {
    public static void assertCommits(List<GitCommit> commits) throws Exception {
        assertEquals(1, commits.size());
        GitCommit commit = commits.getFirst();
        assertEquals(
                "https://github.com/octocat/Hello-World/commit/6dcb09b5b57875f334f61aebed695e2e4193db5e",
                commit.getUrl().toString());
        assertEquals("6dcb09b5b57875f334f61aebed695e2e4193db5e", commit.getSha());
        assertEquals("octocat", commit.getAuthor().getLogin());
        assertEquals("https://github.com/octocat", commit.getAuthor().getUrl().toString());
        assertEquals(
                "https://github.com/images/error/octocat_happy.gif",
                commit.getAuthor().getAvatarUrl().toString());
        assertEquals("Fix all the bugs", commit.getMessage());
        assertEquals(new StdDateFormat().parse("2011-04-14T17:00:48+02:00").toInstant(), commit.getDate());
    }
}
