#!/bin/bash

set -euxo pipefail

DIR=$(dirname "$0")
DC="docker compose --file $DIR/docker-compose.yaml --env-file $DIR/.env"
DR="$DIR/docker-run"

$DC stop
$DC build

$DR backend ./gradlew build --no-daemon
$DR frontend npm install

$DC up --remove-orphans --force-recreate --wait --detach
