import { TestBed } from '@angular/core/testing'
import { AppComponent } from './app.component'
import { MockRender, ngMocks } from 'ng-mocks'
import { AppModule } from './app.module'
import { CommitsComponent } from './commits/commits.component'

describe('AppComponent', () => {
    beforeEach(async () => {
        await TestBed.configureTestingModule(
            ngMocks.guts(AppComponent, AppModule),
        ).compileComponents()
    })

    it('should create the app', () => {
        const fixture = TestBed.createComponent(AppComponent)
        const app = fixture.componentInstance
        expect(app).toBeTruthy()
    })

    it('should have correct title', () => {
        const fixture = TestBed.createComponent(AppComponent)
        const app = fixture.componentInstance
        expect(app.title).toEqual('SquarePeg GitHubing')
    })

    it('should render title', () => {
        const fixture = TestBed.createComponent(AppComponent)
        fixture.detectChanges()
        const compiled = fixture.nativeElement as HTMLElement
        expect(compiled.querySelector('h3')?.textContent).toContain(
            'SquarePeg GitHubing',
        )
    })

    it('should render commits', () => {
        MockRender(AppComponent)
        const commits =
            ngMocks.find<CommitsComponent>('app-commits').componentInstance

        expect(commits).toBeTruthy()
    })
})
