import { TestBed } from '@angular/core/testing'
import { CommitStatusComponent } from './commit-status.component'
import { MockedComponentFixture, MockProvider, MockRender } from 'ng-mocks'
import { CommitService } from '../commit.service'
import { commitMock } from '../../test'
import { GitCommitStatus } from '../model'
import { of } from 'rxjs'

describe('CommitStatusComponent', () => {
    let component: CommitStatusComponent
    let fixture: MockedComponentFixture<CommitStatusComponent>

    beforeEach(async () => {
        await TestBed.configureTestingModule({
            declarations: [CommitStatusComponent],
            providers: [MockProvider(CommitService)],
        }).compileComponents()

        // fixture = TestBed.createComponent(CommitStatusComponent);
        fixture = MockRender(CommitStatusComponent)
        component = fixture.point.componentInstance
        component.commit = commitMock
        fixture.detectChanges()
    })

    it('should create', () => {
        expect(component).toBeTruthy()
    })

    it('should fetch status on init', () => {
        const commitService = fixture.point.injector.get(
            CommitService,
        ) as jasmine.SpyObj<CommitService>
        commitService.getStatus.calls.reset()

        component.ngOnInit()

        expect(commitService.getStatus).toHaveBeenCalledOnceWith(commitMock)
    })

    it('should render success', () => {
        component.status = of(GitCommitStatus.Success)
        fixture.detectChanges()

        const span = fixture.nativeElement.querySelector('span.success')
        expect(span).toBeTruthy()
    })

    it('should render failure', () => {
        component.status = of(GitCommitStatus.Failure)
        fixture.detectChanges()

        const span = fixture.nativeElement.querySelector('span.failure')
        expect(span).toBeTruthy()
    })

    it('should render pending', () => {
        component.status = of(GitCommitStatus.Pending)
        fixture.detectChanges()

        const span = fixture.nativeElement.querySelector('span.pending')
        expect(span).toBeTruthy()
    })

    it('shouldnt render if missing', () => {
        component.status = of(undefined)
        fixture.detectChanges()

        const span = fixture.nativeElement.querySelector('span')
        expect(span).toBeFalsy()
    })
})
