import { Component, Input, OnInit } from '@angular/core'
import { GitCommit, GitCommitStatus } from '../model'
import { Observable } from 'rxjs'
import { CommitService } from '../commit.service'

@Component({
    selector: 'app-commit-status',
    templateUrl: './commit-status.component.html',
    styleUrls: ['./commit-status.component.scss'],
})
export class CommitStatusComponent implements OnInit {
    @Input({ required: true }) commit!: GitCommit
    status!: Observable<GitCommitStatus | undefined>
    statusEnum = GitCommitStatus

    constructor(private commitService: CommitService) {}

    ngOnInit(): void {
        this.status = this.commitService.getStatus(this.commit)
    }
}
