import { TestBed } from '@angular/core/testing'
import { CommitsComponent } from './commits.component'
import { MockedComponentFixture, MockProvider, MockRender } from 'ng-mocks'
import { CommitService } from '../commit.service'

describe('CommitsComponent', () => {
    let component: CommitsComponent
    let fixture: MockedComponentFixture<CommitsComponent>

    beforeEach(async () => {
        await TestBed.configureTestingModule({
            declarations: [CommitsComponent],
            providers: [MockProvider(CommitService)],
        }).compileComponents()

        fixture = MockRender(CommitsComponent)
        component = fixture.point.componentInstance
        fixture.detectChanges()
    })

    it('should create', () => {
        expect(component).toBeTruthy()
    })

    it('should fetch commits on init', () => {
        const commitService = fixture.point.injector.get(
            CommitService,
        ) as jasmine.SpyObj<CommitService>
        commitService.getCommits.calls.reset()

        component.ngOnInit()

        expect(commitService.getCommits).toHaveBeenCalledTimes(1)
    })
})
