import { Component, OnInit } from '@angular/core'
import { CommitService } from '../commit.service'
import { Observable } from 'rxjs'
import { GitCommit } from '../model'

@Component({
    selector: 'app-commits',
    templateUrl: './commits.component.html',
    styleUrls: ['./commits.component.scss'],
})
export class CommitsComponent implements OnInit {
    commits!: Observable<GitCommit[]>

    constructor(private commitService: CommitService) {}

    ngOnInit(): void {
        this.commits = this.commitService.getCommits()
    }

    fetch(): void {
        this.commits = this.commitService.fetchCommits()
    }
}
