export type Url = string

interface GitUser {
    login: string
    url: Url
    avatarUrl: Url
}

export interface GitCommit {
    url: Url
    sha: string
    author: GitUser
    message: string
    date: Date
    dateAgo: string
}

export enum GitCommitStatus {
    Pending = 'PENDING',
    Success = 'SUCCESS',
    Failure = 'FAILURE',
}
