import { GitCommit, GitCommitStatus } from './app/model'
import { ngMocks } from 'ng-mocks'
import { CommitService } from './app/commit.service'
import { of } from 'rxjs'

export const commitMock: GitCommit = {
    url: 'https://github.com/commit',
    sha: 'mySha',
    author: {
        login: 'username',
        url: 'https://github.com/author',
        avatarUrl: 'https://github.com/avatar',
    },
    message: 'My fancy commit message',
    date: new Date('2013-04-27T17:10:01.000+02:00'),
    dateAgo: '8 years ago',
}

export const commitRawMock = {
    ...commitMock,
    date: '2013-04-27T17:10:01.000+02:00',
}

ngMocks.autoSpy('jasmine')

ngMocks.defaultMock(CommitService, () => ({
    getCommits: jasmine.createSpy().and.callFake(() => of([commitMock])),
    getStatus: jasmine
        .createSpy()
        .and.callFake(() => of(GitCommitStatus.Success)),
}))
